#!/usr/local/bin/perl
#-----------------------------------------------------------------------------
# 404report.cgi - ４０４エラーを管理者にメールで報告するプログラム - 
#-----------------------------------------------------------------------------
# License GPL
# Copyright 2009 CASEY
# History
# - 2009-01-04 Ver.0.01 初版作成
#------------------------------------------------------------------------------
# [注意事項]
#  - このプログラムは起動すると即座に動作、報告する。データの蓄積を行わないので
#    起動が多ければ膨大な報告が寄せられることがあるので注意すること。
#    （特にメール送信や負荷に関してサーバー管理者に迷惑をかけないように注意）
#  - メールに日本語を使うことを想定していない
#    （日本語を使いたい場合はエンコードしてあげれば行けると思う）
#  - メールの送信認証には対応していない
# [.heaccessによる起動]
#  - 404, 呼び出したファイルが存在しないことの通知
#  - 500, CGIの呼び出しがエラーになったことの通知（非推奨）
# [.htaccess記述例]
#   ErrorDocument 404 /404report.cgi
#------------------------------------------------------------------------------
use strict;
use CGI::Carp qw(fatalsToBrowser);
use Mail::Sendmail;
use Encode;
use utf8;

# 設定ここから ----------------------------------------------------------------
my $to		= '*******@hotmail.com';		# 連絡先メールアドレス

# 以降は変更しない ------------------------------------------------------------
my $from	= 'root@localhost';				# 送信者
my $ver		= '404report.cgi Ver.0.01';		# プログラム名
my $subject = $ver;							# 件名

$|=1;

# アクセス元が取得できない場合は処理を中断
#   コメントアウトすればすべてのエラーを通知させることができるが、
#   ハッキングプログラムなどがわざわざ存在しないものや、
#   攻撃コードを持ってくることもあるので、注意が必要。
#   どんなサーバでも最低3000件/Dayくらいの不正アクセスはあるハズ。
if(!$ENV{'HTTP_REFERER'}){
	print "Content-Type: text/html; charset=UTF-8\n\n";
	print "STOP [CHK_REFERER]";
	exit;
}

# 日付処理
my @youbi = ('Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fry', 'Sat');
my($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
$year += 1900;
$mon += 1;
my $dt = "$year/$mon/$mday($youbi[$wday]) $hour:$min:$sec";

# メッセージ組み立て
my $message = "This error was reported to the manager.\n\n";
$message .= "$ENV{'REQUEST_URI'}\n\n";

if($ENV{'HTTP_REFERER'}){
	$message .= "Ref = $ENV{'HTTP_REFERER'}\n";
}else{
	$message .= "Ref = ?\n";
}

$message .= "\n";
$message .= "$ENV{'REMOTE_ADDR'}\n";
$message .= "$dt\n";
$message .= "\n(C)CASEY.JP, $ver\n";

# エンコード
$subject = encode("MIME-Header-ISO_2022_JP", $subject);
$message = encode("iso-2022-jp", "$message");

# メール作成
my %mail = (
	"Content-Type" => 'text/plain;charset="iso-2022-jp"',
	To             => $to,
	From           => $from,
	Subject        => $subject,
	Message        => $message,
);

# メール送信
sendmail(%mail);

# 完了画面出力開始 ------------------------------------------------------------
# STATUS 404, 500 を返してもいいかもしれないけど…(Defaultは当然200)
$message =~ s/\n/<br>\n/g;
print "Content-Type: text/html; charset=UTF-8\n\n";
print <<"END_HTML";
<h1>ERROR</h1>
$message
END_HTML
