//
// Auther:
//   CASEY, www.casey.jp
//
// File:
//   svcheck.js, utf-8, lf, GPL
//
// History:
//   Ver.0.01a  2010.04.24 alpha, need proxy on your server
//   Ver.0.02a  2010.04.25 alpha, bug fix and more
//   Ver.0.03a  2010.04.25 alpha, add mode switch standalone and proxy
//   Ver.0.04b  2010.04.26 beta, add auto check
//   Ver.0.05b  2010.04.26 beta, add force mode
//   Ver.0.06b  2010.04.26 beta, add display name
//   Ver.0.07b  2010.04.26 beta, color code change
//
// WARNING:
//  * When using this program, and the country has set up the server and not
//    have to be careful before the law in your area of residence.
//  * Must be careful not to exploit your server for proxy program.
//  * Adding to the list server other than your own is not possible.
//  * This program is an example. You need to complete.
//  * Please operate in about 15 minutes at least. Also it should not be less
//    than one minute.
//
// INFORMATION:
//  Script execute table
//  +-----------------------------------------------------------------------------+
//  | Engine              | W | P | R | About                                     |
//  +=============================================================================+
//  | IE 8.0.6001.187028  | L | n | o | ok                                        |
//  +-----------------------------------------------------------------------------+
//  | IE 8.0.6001.187028  | L | y | o | ok                                        |
//  +-----------------------------------------------------------------------------+
//  | IE 8.0.6001.187028  | I | n | o | ok                                        |
//  +-----------------------------------------------------------------------------+
//  | IE 8.0.6001.187028  | I | y | o | ok                                        |
//  +-----------------------------------------------------------------------------+
//  | Gecko 1.9.1.9       | L | n | x | bad                                       |
//  +-----------------------------------------------------------------------------+
//  | Gecko 1.9.1.9       | L | y | x | bad                                       |
//  +-----------------------------------------------------------------------------+
//  | Gecko 1.9.1.9       | I | n | x | bad                                       |
//  +-----------------------------------------------------------------------------+
//  | Gecko 1.9.1.9       | I | y | x | bad                                       |
//  +-----------------------------------------------------------------------------+
//  | WebKit 533.3 r56034 | L | n | x | NETWORK_ERR: XMLHttpRequest Exception 101 |
//  +-----------------------------------------------------------------------------+
//  | WebKit 533.3 r56034 | L | y | x | NETWORK_ERR: XMLHttpRequest Exception 101 |
//  +-----------------------------------------------------------------------------+
//  | WebKit 533.3 r56034 | I | n | x | NETWORK_ERR: XMLHttpRequest Exception 101 |
//  +-----------------------------------------------------------------------------+
//  | WebKit 533.3 r56034 | I | y | o | ok                                        |
//  +-----------------------------------------------------------------------------+
//  | iPhone OS3.1.3      | I | n | x | NETWORK_ERR: XMLHttpRequest Exception 101 |
//  +-----------------------------------------------------------------------------+
//  | iPhone OS3.1.3      | I | y | o | ok                                        |
//  +-----------------------------------------------------------------------------+
//  *IE:InternetExplorer/W:Where/I:Internet/L:Local/P:Proxy/R:Result/y:yes/n:no

// [ start settings ]----------------------------------------------------------

// access mode
//   0 = proxy / [1] = standalone mode
var standalone = 1;

// proxy mode need proxy address (no need standalone mode)
var proxy = "http://www.xxxxx.jp/lib/ba-simple-proxy.php?url=";

// force mode ( add query "t=xxxxxxxx" x = unixtime)
//   1 = force mode on / [0] = force mode off
//   By adding time to a query, and specifies the different access to
//   the browser. This seems to be effective in preventing the cache.
var force = 0;

// interval(min)
var INTERVAL = 15;

// html div id
var tableId = "res";

// [ end of settings ]---------------------------------------------------------

var tmrID;

// to msec
var INTERVAL_MIN = INTERVAL * 60 * 1000;

var SCRIPT_NAME = "Server Check Script ";
var VERSION = "0.07b";

// interval function ==============================
var interval = function(){
	var request = createXMLHttpRequest();
	
	// clear table
	document.getElementById(tableId).innerHTML=''
	
	// create table
	table = document.createElement("TABLE")
	tbody = document.createElement("TBODY")
	
	// add table to div, include tbody
	table.insertBefore(tbody, null)
	document.getElementById(tableId).insertBefore(table, null)
	
	// get unixtime
	var t = "foobar=" + parseInt((new Date)/1000);
	
	// roop
	//for(var i=0; i<go.length; i++){
	for (var i in go) {
		var target = go[i];
		var line = 'n/a';
		if(!target){
			continue;
		}
		
		if(standalone){
			var url = force ? target + "?" + t : target;
		}else{
			var url = proxy + encodeURIComponent(target);
			url = force ? url + "&" + t : url;
		}
		
		tr	 = document.createElement("TR")
		tbody.insertBefore(tr, null)
		
		request.open("GET", url, false);
		request.onreadystatechange = function() {
			//if (request.readyState == 4 && request.status == 200) {
			if (request.readyState == 4) {
				var offline = 1;
				
				if(standalone){
					if(request.status == 200){
						offline = 0;
					}
				}else{
					var jsonData = request.responseText;
					var res = eval( "(" + jsonData + ")" );
					if(res.status.http_code == 200){
						offline = 0;
					}
				}
				
				// status
				td = document.createElement("TD")
				var bc = "salmon";
				if(offline){
					//line = "Offline";
					text = document.createTextNode("Off-Line")
				}else{
					//line = "OnLine";
					bc = "limegreen";
					text = document.createTextNode("On-Line")
				}
				td.style.backgroundColor = bc;
				td.style.color = 'white';
				td.style.textAlign = 'center';
				tr.insertBefore(td, null)
				td.insertBefore(text, null)
				
				// server
				td	 = document.createElement("TD")
				td.style.backgroundColor = bc;
				//text = document.createTextNode(target)
				td.style.textAlign = 'right';
				td.style.color = 'white';
				text = document.createTextNode(i)
				tr.insertBefore(td, null)
				td.insertBefore(text, null)
			}
		}
		request.send("");
	}
	// roop end
	var now = new Date();
	var last = "LastCheck: " + now.toLocaleString() + " (LocalTime) <br />";
	var mode = '[ mode:';
	mode += (standalone) ? 'STANDALONE / ' : 'PROXY / ';
	mode = (force) ? mode + 'foce:ON' : mode + 'force:OFF';
	mode += '/ Interval:' + INTERVAL + "min";
	mode += ' ]<br /><a href="http://pc.casey.jp" target="_blank">';
	mode += SCRIPT_NAME + VERSION + ' By (C) CASEY.JP 2010</a>';
	document.getElementById("time").innerHTML = last + mode;
};

// ----------------------------------------------
//   createXMLHttpRequest
// ----------------------------------------------
//  create XMLHttp object for multi browser
function createXMLHttpRequest() {
	return this.XMLHttpRequest ? new XMLHttpRequest() : new ActiveXObject("Microsoft.XMLHTTP");
}

// ----------------------------------------------
//   start
// ----------------------------------------------
//  start automatic check
function start_interval(){
	// enable bottun
	eSwitch("stop", false);
	
	// disable bottun
	eSwitch("start", true);
	eSwitch("check", true);
	
	// setting a timer and function
    tmrID = setInterval( interval, INTERVAL_MIN);
}

// ----------------------------------------------
//   stop
// ----------------------------------------------
//  stop automatic check
function stop_interval(){
	// disable bottun
	eSwitch("stop", true);
	
	// enable bottun
	eSwitch("start", false);
	eSwitch("check", false);
	
	// clear timer
    clearInterval(tmrID);
}

// ----------------------------------------------
//   check
// ----------------------------------------------
// one time execute interval() when push check bottun
function check(){
	// disable bottun
	eSwitch("check", true);
	eSwitch("start", true);
	
	// enable bottun, after INTERVAL_MIN, one time execute
	setTimeout( "eSwitch('check', false);eSwitch('start', false);", INTERVAL_MIN);
	
	// one time ececute check
	interval();
}

// ----------------------------------------------
//   element disable switch
// ----------------------------------------------
//   usage:
//     eSwitch(element, bool)
//       true: disable
//       false: enable
function eSwitch(e, b){
	document.getElementById(e).disabled = b;
}
